const BaseOpenAPIGatewayClient = require('../base-open-api-gateway-client')
const className = 'NagNetworkListApi'

module.exports = class NagNetworkListApi extends BaseOpenAPIGatewayClient {
    GetListItemFileInfo ({ listName, itemId, bNeedPacked, connectionId }, _, cacheConfig) {
        return this.baseRequest({
            command: `${className}.GetListItemFileInfo`,
            data: {
                listName,
                itemId,
                bNeedPacked
            },
            connectionId
        }, cacheConfig)
        .then(this.getBody)
    }

    /**
     * @method
     * @description Retrieves information about file associated with network list item.
     * @param {object} params
     * @param {string} params.listName - Network list name
     * @param {string} params.itemId - Network list item identifier
     * @param {boolean} params.bNeedPacked - if true than will be get info about packed content of the file. It is useful if file is the virus and it is needed to load it.
     * @param {string} params.productName - Product internal name
     * @param {string} params.productVersion - Product internal version
     * @param {String} params.connectionId - Connection id
     * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
     * @returns {Number} - lResult Integer, value from enum NLSTFileOperationResult:
     * - 0	Operation successfully completed.
     * - 1	The file chunk has been successfully read and it was the last chunk of the file
     * - 2	File not found
     * - 3	Operation completed with error
     * - 4	File is not ready to reading yet
     * - 5	The operation is no supported by the list
     */
    GetListItemFileInfo2 ({ listName, itemId, bNeedPacked, productName, productVersion, connectionId }, _, cacheConfig) {
        return this.baseRequest({
            command: `${className}.GetListItemFileInfo2`,
            data: {
                listName,
                itemId,
                bNeedPacked,
                productName,
                productVersion
            },
            connectionId
        }, cacheConfig)
            .then(this.getBody)
    }

    GetListItemFileChunk ({ listName, itemId, bNeedPacked, ulStartPos, lBytesToRead, connectionId }, _, cacheConfig) {
        return this.baseRequest({
            command: `${className}.GetListItemFileChunk`,
            data: {
                listName,
                itemId,
                bNeedPacked,
                ulStartPos,
                lBytesToRead
            },
            connectionId
        }, cacheConfig)
        .then(this.getBody)
    }

    /**
     * @method
     * @description Retrieves chunk of the file associated with network list item.
     * @param {object} props
     * @param {string} props.listName - Network list name
     * @param {string} props.itemId - Network list item identifier
     * @param {boolean} props.bNeedPacked - if true than will be get info about packed content of the file. It is useful if file is the virus and it is needed to load it.
     * @param {number} props.ulStartPos - start position of the chunk
     * @param {number} props.lBytesToRead - number of bytes to read
     * @param {string} props.productName - Product internal name
     * @param {string} props.productVersion - Product internal version
     * @param {String} props.connectionId - Connection id
     * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
     * @returns {Promise<Number>} - lResult Integer, value from enum NLSTFileOperationResult:
     * - 0	Operation successfully completed.
     * - 1	The file chunk has been successfully read and it was the last chunk of the file
     * - 2	File not found
     * - 3	Operation completed with error
     * - 4	File is not ready to reading yet
     * - 5	The operation is no supported by the list
     */
    GetListItemFileChunk2 ({ listName, itemId, bNeedPacked, ulStartPos, lBytesToRead, productName, productVersion, connectionId }, _, cacheConfig) {
        return this.baseRequest({
            command: `${className}.GetListItemFileChunk2`,
            data: {
                listName,
                itemId,
                bNeedPacked,
                ulStartPos,
                lBytesToRead,
                productName,
                productVersion
            },
            connectionId
        }, cacheConfig)
            .then(this.getBody)
    }
}
