const BaseOpenAPIGatewayClient = require('../base-open-api-gateway-client')
const className = 'NagRdu'

module.exports = class NagRdu extends BaseOpenAPIGatewayClient {
  ChangeTraceParams ({ szwProductID, nTraceLevel, connectionId }, _, cacheConfig) {
    return this.baseRequest({
        command: `${className}.ChangeTraceParams`,
        data: {
          szwProductID,
          nTraceLevel
        },
        connectionId
      }, cacheConfig)
      .then(this.getBody)
  }

  ChangeTraceRotatedParams ({ szwProductID, nTraceLevel, nPartsCount, nMaxPartSize, connectionId }, _, cacheConfig) {
    return this.baseRequest({
        command: `${className}.ChangeTraceRotatedParams`,
        data: {
          szwProductID,
          nTraceLevel,
          nPartsCount,
          nMaxPartSize
        },
        connectionId
      }, cacheConfig)
      .then(this.getBody)
  }

  ChangeXperfBaseParams ({ szwProductID, nTraceLevel, nXPerfMode, connectionId }, _, cacheConfig) {
    return this.baseRequest({
        command: `${className}.ChangeXperfBaseParams`,
        data: {
          szwProductID,
          nTraceLevel,
          nXPerfMode
        },
        connectionId
      }, cacheConfig)
      .then(this.getBody)
  }

  ChangeXperfRotatedParams ({ szwProductID, nTraceLevel, nXPerfMode, nMaxPartSize, connectionId }, _, cacheConfig) {
    return this.baseRequest({
        command: `${className}.ChangeXperfRotatedParams`,
        data: {
          szwProductID,
          nTraceLevel,
          nXPerfMode,
          nMaxPartSize
        },
        connectionId
      }, cacheConfig)
      .then(this.getBody)
  }

  CreateAndDownloadDumpAsync ({ szwProcessName, connectionId }, _, cacheConfig) {
    return this.baseRequest({
        command: `${className}.CreateAndDownloadDumpAsync`,
        data: {
          szwProcessName
        },
        connectionId
      }, cacheConfig)
      .then(this.getBody)
  }

  DeleteFile ({ szwRemoteFile, connectionId }, _, cacheConfig) {
    return this.baseRequest({
        command: `${className}.DeleteFile`,
        data: {
          szwRemoteFile
        },
        connectionId
      }, cacheConfig)
      .then(this.getBody)
  }

  DeleteFiles ({ pRemoteFiles, connectionId }, _, cacheConfig) {
    return this.baseRequest({
        command: `${className}.DeleteFiles`,
        data: {
          pRemoteFiles
        },
        connectionId
      }, cacheConfig)
      .then(this.getBody)
  }

  DownloadCommonDataAsync ({ connectionId }, _, cacheConfig) {
    return this.baseRequest({
        command: `${className}.DownloadCommonDataAsync`,
        data: {},
        connectionId
      }, cacheConfig)
      .then(this.getBody)
  }

  DownloadEventlogAsync ({ szwEventLog, connectionId }, _, cacheConfig) {
    return this.baseRequest({
        command: `${className}.DownloadEventlogAsync`,
        data: {
          szwEventLog
        },
        connectionId
      }, cacheConfig)
      .then(this.getBody)
  }

  ExecuteFileAsync ({ szwURL, szwShortExecName, szwParams, connectionId }, _, cacheConfig) {
    return this.baseRequest({
        command: `${className}.ExecuteFileAsync`,
        data: {
          szwURL,
          szwShortExecName,
          szwParams
        },
        connectionId
      }, cacheConfig)
      .then(this.getBody)
  }

  ExecuteGsiAsync ({ connectionId }, _, cacheConfig) {
    return this.baseRequest({
        command: `${className}.ExecuteGsiAsync`,
        data: {},
        connectionId
      }, cacheConfig)
      .then(this.getBody)
  }

  GetCurrentHostState ({ connectionId }, _, cacheConfig) {
    return this.baseRequest({
        command: `${className}.GetCurrentHostState`,
        data: {},
        connectionId
      }, cacheConfig)
      .then(this.getResult)
  }

  GetUrlToDownloadFileFromHost ({ szwRemoteFile, connectionId }, _, cacheConfig) {
    return this.baseRequest({
        command: `${className}.GetUrlToDownloadFileFromHost`,
        data: {
          szwRemoteFile
        },
        connectionId
      }, cacheConfig)
      .then(this.getBody)
  }

  GetUrlToUploadFileToHost ({ connectionId }, _, cacheConfig) {
    return this.baseRequest({
        command: `${className}.GetUrlToUploadFileToHost`,
        data: {},
        connectionId
      }, cacheConfig)
      .then(this.getBody)
  }

  RunKlnagchkAsync ({ szwProductID, connectionId }, _, cacheConfig) {
    return this.baseRequest({
        command: `${className}.RunKlnagchkAsync`,
        data: {
          szwProductID
        },
        connectionId
      }, cacheConfig)
      .then(this.getBody)
  }

  SetProductStateAsync ({ szwProductID, nNewState, connectionId }, _, cacheConfig) {
    return this.baseRequest({
        command: `${className}.SetProductStateAsync`,
        data: {
          szwProductID,
          nNewState
        },
        connectionId
      }, cacheConfig)
      .then(this.getBody)
  }
}
