const BaseOpenAPIGatewayClient = require('../base-open-api-gateway-client')
const className = 'NagRemoteScreen'

module.exports = class NagRemoteScreen extends BaseOpenAPIGatewayClient {
  GetExistingSessions ({ nType, connectionId }, _, cacheConfig) {
    return this.baseRequest({
      command: `${className}.GetExistingSessions`,
      data: {
        nType
      },
      connectionId
    }, cacheConfig)
      .then(this.getBody)
  }

  OpenSession ({ nType, szwID, connectionId }, _, cacheConfig) {
    return this.baseRequest({
      command: `${className}.OpenSession`,
      data: {
        nType,
        szwID
      },
      connectionId
    }, cacheConfig)
      .then(this.getBody)
  }

  CloseSession ({ pSharingHandle, connectionId }, _, cacheConfig) {
    return this.baseRequest({
      command: `${className}.CloseSession`,
      data: {
        pSharingHandle
      },
      connectionId
    }, cacheConfig)
      .then(this.getBody)
  }

  GetDataForTunnel ({ pSharingHandle, connectionId }, _, cacheConfig) {
    return this.baseRequest({
      command: `${className}.GetDataForTunnel`,
      data: {
        pSharingHandle
      },
      connectionId
    }, cacheConfig)
      .then(this.getBody)
  }

  GetWdsData ({ pSharingHandle, nLocalPortNumber, connectionId }, _, cacheConfig) {
    return this.baseRequest({
      command: `${className}.GetWdsData`,
      data: {
        pSharingHandle,
        nLocalPortNumber
      },
      connectionId
    }, cacheConfig)
      .then(this.getBody)
  }
}
