const BaseOpenAPIClient = require('../base-open-api-client')
const className = 'NlaDefinedNetworks'

module.exports = class NlaDefinedNetworks extends BaseOpenAPIClient {

  /**
   * Add nla-defined network
   * @param params
   * @param {string} params.wstrNetworkName - Network must not exist
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @returns {number} - newly created network id
   */
  async AddNetwork ({ wstrNetworkName }, connection, cacheConfig) {
    const body = await this.baseRequest({
      command: `${className}.AddNetwork`,
      data: {
        wstrNetworkName
      },
      connection
    }, cacheConfig)
    return this.getBody(body)
  }

  /**
   * Delete NLA-defined network
   * @param {object} params
   * @param {number} params.nNetworkId - id of network to delete
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   */
  async DeleteNetwork ({ nNetworkId }, connection, cacheConfig) {
    const body = await this.baseRequest({
      command: `${className}.DeleteNetwork`,
      data: {
        nNetworkId
      },
      connection
    }, cacheConfig)
    return this.getBody(body)
  }

  /**
   * Get NLA-defined network info
   * @param {object} params
   * @param {number} params.nNetworkId - id of network
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @returns {object} params.pNetwork - NLA-defined network
   */
  async GetNetworkInfo ({ nNetworkId }, connection, cacheConfig) {
    const body = await this.baseRequest({
      command: `${className}.GetNetworkInfo`,
      data: {
        nNetworkId
      },
      connection
    }, cacheConfig)
    return this.getBody(body)
  }

  /**
   * Get list of all NLA-defined networks
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @returns {Array<object>} - Array of NLA-defined networks
   */
  async GetNetworksList (data, connection, cacheConfig) {
    const body = await this.baseRequest({
      command: `${className}.GetNetworksList`,
      connection
    }, cacheConfig)
    return this.getBody(body)
  }

  /**
   * Change nla-defined network
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @param pNetwork - NLA-defined network
   */
  async SetNetworkInfo ({ pNetwork }, connection, cacheConfig) {
    const body = await this.baseRequest({
      command: `${className}.SetNetworkInfo`,
      data: {
        pNetwork: this.serialize(pNetwork)
      },
      connection
    }, cacheConfig)
    return this.getBody(body)
  }
}
