const baseOpenAPIClient = require('../base-open-api-client')
const className = 'OAuth2'

module.exports = class OAuth2 extends baseOpenAPIClient {
  GetClients ({ nFilterByState }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.GetClients`,
      data: {
        nFilterByState
      },
      connection
    }, cacheConfig).then(this.deserialize)
  }

  GetNewClients ({}, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.GetNewClients`,
      connection
    }, cacheConfig).then(this.deserialize)
  }

  GetClientsToRegistration ({}, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.GetClientsToRegistration`,
      connection
    }, cacheConfig).then(this.deserialize)
  }

  ApproveNewClients ({ pClients }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.ApproveNewClients`,
      data: {
        pClients: this.serialize(pClients)
      },
      connection
    }, cacheConfig).then(this.getResult)
  }

  DeclineNewClients ({ pClientIds }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.DeclineNewClients`,
      data: {
        pClientIds
      },
      connection
    }, cacheConfig).then(this.getResult)
  }

  GetResServers ({ nFilterByState }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.GetResServers`,
      data: {
        nFilterByState
      },
      connection
    }, cacheConfig).then(this.deserialize)
  }

 	GetNewResServers ({}, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.GetNewResServers`,
      connection
    }, cacheConfig).then(this.deserialize)
  }

 	ApproveNewResServers ({ pResServers }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.ApproveNewResServers`,
      data: {
        pResServers: this.serialize(pResServers)
      },
      connection
    }, cacheConfig).then(this.getResult)
  }

 	DeclineNewResServers ({ pResServerIds }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.DeclineNewResServers`,
      data: {
        pResServerIds
      },
      connection
    }, cacheConfig).then(this.getResult)
  }
}
