const BaseOpenAPIClient = require('../base-open-api-client')
const className = 'PatchParameters'

module.exports = class PatchParameters extends BaseOpenAPIClient {
  /**
   * Get template for command
   * @param {object} params
   * @param {bigint} params.patchID - Identification of patch in vapm
   * @param {number} params.locID - Patch LCID
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @returns {Promise<object>} - parTemplate
   */
  GetTemplate ({ patchID, locID }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.GetTemplate`,
      data: { patchID, locID },
      connection
    }, cacheConfig)
      .then(this.deserialize)
  }

  /**
   * Set values for parameters of command
   * @param {object} params
   * @param {bigint} params.patchID - Identification of patch in vapm
   * @param {number} params.locID - Identification of localization of patch in vapm
   * @param {object} params.parsValues - Parameters to change
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   */
  SetValues ({ patchID, locID, parsValues }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.SetValues`,
      data: { patchID, locID, parsValues },
      connection
    }, cacheConfig)
      .then(this.deserialize)
  }

  /**
   * Get install command for patch
   * @param {object} params
   * @param {bigint} params.patchID - Identification of patch in vapm
   * @param {number} params.locID - Patch LCID
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @returns {Promise<object>} - parsValues
   */
  GetValues ({ patchID, locID }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.GetValues`,
      data: { patchID, locID },
      connection
    }, cacheConfig)
      .then(this.deserialize)
  }

  /**
   * Set values for parameters of command
   * @param {object} params
   * @param {number} params.packageId - Identification of package
   * @param {object} params.parsValues - Parameters to change
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   */
  SetValuesByPkg ({ packageId, parsValues }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.SetValuesByPkg`,
      data: {
        packageId,
        parsValues: this.serialize(parsValues)
      },
      connection
    }, cacheConfig)
      .then(this.deserialize)
  }

  /**
   * Get install command for patch
   * @param {object} params
   * @param {number} params.packageId - Identification of package
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @returns {Promise<object>} - parsValues
   */
  GetValuesByPkg ({ packageId }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.GetValuesByPkg`,
      data: { packageId },
      connection
    }, cacheConfig)
      .then(this.deserialize)
  }
}
