const BaseOpenAPIClient = require('../base-open-api-client')
const className = 'PLCDevApi'

module.exports = class PLCDevApi extends BaseOpenAPIClient {
  /**
   * Remove PLC device.
   * @param {object} params
   * @param {string} params.pPLCId - PLC device id. binary data as array of 16 bytes.
   * @param connection
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   */
  async DeletePLC ({ pPLCId }, connection, cacheConfig) {
    const body = await this.baseRequest({
      command: `${className}.DeletePLC`,
      data: { pPLCId },
      connection
    }, cacheConfig)

    return this.getResult(body)
  }

  /**
   * Acquire attributes of specified PLC device.
   * Returns attributes of specified PLC device.
   * @param {object} params
   * @param {string} params.pPLCId - PLC device id. binary data as array of 16 bytes.
   * @param {object} params.parOptions - reserved
   * @param connection
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @returns { Promise<{result: *}> } object containing attributes of specified PLC device, see List of plc device attributes.
   */
  async GetPLC ({ pPLCId, parOptions = null }, connection, cacheConfig) {
    const body = await this.baseRequest({
      command: `${className}.GetPLC`,
      data: {
        pPLCId,
        parOptions: this.serialize(parOptions)
      },
      connection
    }, cacheConfig)

    return this.getResult(body)
  }

  /**
   * Adds/Updates PLC device.
   * @param {object} params
   * @param {string} params.pPLCId - PLC device id. binary data as array of 16 bytes.
   * @param {object} params.pPLCInfo - object containing device attributes, see List of plc device attributes.
   * Following attributes are require "KLPLC_DisplayName
   * @param connection
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   */
  async UpdatePLC ({ pPLCId, pPLCInfo }, connection, cacheConfig) {
    const body = await this.baseRequest({
      command: `${className}.UpdatePLC`,
      data: {
        pPLCId,
        pPLCInfo: this.serialize(pPLCInfo)
      },
      connection
    }, cacheConfig)

    return this.getResult(body)
  }
}
