const BaseOpenAPIClient = require('../base-open-api-client')
const className = 'PluginData'

module.exports = class PluginData extends BaseOpenAPIClient {
/**
   * @description Store plugin data.
   * @param {object} params
   * @param {string} params.wstrPluginName
   * @param {object} params.pData
   * @param {Connection} connection
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @return {Promise.<object>}
   */
  StorePluginData ({wstrPluginName, pData}, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.StorePluginData`,
      data: {
        wstrPluginName,
        pData: this.serialize(pData)
      },
      connection
    }, cacheConfig)
    .then(this.getResult)
  }

  /**
   * @description Load plugin data.
   * @param {object} params
   * @param {string} params.wstrPluginName
   * @param {Connection} connection
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @return {Promise.<object>}
   */
  LoadPluginData ({wstrPluginName}, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.LoadPluginData`,
      data: {
        wstrPluginName
      },
      connection
    }, cacheConfig)
    .then(this.deserialize)
  }
}
