const BaseOpenAPIClient = require('../base-open-api-client')
const className = 'ProductBackendIntegration'

module.exports = class ProductBackendIntegration extends BaseOpenAPIClient {
  /**
   * Set up integration with product backend
   * @param {object} params
   * @param {string} params.wstrProdName - product name
   * @param {string} params.wstrProdVersion - product version
   * @param {string} params.pRefreshToken - integration refresh token
   * @param {number} params.nTokenTtl - time to live of refresh token in seconds, since moment of this call
   * @param {*} connection
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   */
  async SetIntegrationToken ({ wstrProdName, wstrProdVersion, pRefreshToken, nTokenTtl }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.SetIntegrationToken`,
      data: {
        wstrProdName,
        wstrProdVersion,
        pRefreshToken,
        nTokenTtl
      },
      connection
    }, cacheConfig).then(this.getResult)
  }

  /**
   * Remove integration with product backend
   * @param {object} params
   * @param {string} params.wstrProdName - product name
   * @param {string} params.wstrProdVersion - product version
   * @param {*} connection
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   */
  async DeleteIntegrationToken ({ wstrProdName, wstrProdVersion }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.DeleteIntegrationToken`,
      data: {
        wstrProdName,
        wstrProdVersion
      },
      connection
    }, cacheConfig).then(this.getResult)
  }

  /**
   * Check whether KSC server has valid integration access token
   * @param {object} params
   * @param {string} params.wstrProdName - product name
   * @param {string} params.wstrProdVersion - product version
   * @param {*} connection
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   */
  async IfIntegrationAccessTokenValid ({ wstrProdName, wstrProdVersion }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.IfIntegrationAccessTokenValid`,
      data: {
        wstrProdName,
        wstrProdVersion
      },
      connection
    }, cacheConfig).then(this.getResult)
  }
}
