const BaseOpenAPIClient = require('../base-open-api-client')
const className = 'ProductUserTokenIssuer'

module.exports = class ProductUserTokenIssuer extends BaseOpenAPIClient {
  /**
   * Issue user token
   * @param params
   * @param {string} params.wstrProductName - product name
   * @param {string} params.wstrProductVersion - product version
   * @param {*} connection
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @returns {Promise<string>}
   */
  async IssueUserToken ({ wstrProductName, wstrProductVersion }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.IssueUserToken`,
      data: { wstrProductName, wstrProductVersion },
      connection
    }, cacheConfig).then(this.getBody)
  }

  /**
   * Revoke user token
   * @param params
   * @param {string} params.wstrProductName - product name
   * @param {string} params.wstrProductVersion - product version   
   * @param {*} connection
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @returns {Promise<string>}
   */
  async RevokeUserToken ({ wstrProductName, wstrProductVersion }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.RevokeUserToken`,
      data: { wstrProductName, wstrProductVersion },
      connection
    }, cacheConfig).then(this.getResult)
  }
}
