const BaseOpenAPIClient = require('../base-open-api-client')
const className = 'QBTNetworkListApi'

module.exports = class QBTNetworkListApi extends BaseOpenAPIClient {

    /**
     * Initiate action under the specified files from specified network list.
     * @param {object} params
     * @param {string} params.listName - name of the network list.
     * @param {array} params.pItemsIds - collection of the file identifiers. Each entry of the array is {number} identifier of the file. (see "nId" attribute from Quarantine, Backup, TIF lists)
     * @param {string} params.taskName - name of the action ["RestoreObj"	Restore object from quarantine/backup, "DeleteObj"	Delete object from quarantine/backup, "ScanQuarantine"	Scan object on quarantine/tif]
     * @param {Connection} connection
     * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
     * @deprecated pTaskParams	(params). Deprecated. May be empty but should be not null
     * @returns 
     */
    async AddListItemsTask ({listName, pItemsIds, taskName}, connection, cacheConfig) {
        const body = await this.baseRequest({
            command: `${className}.AddListItemsTask`,
            data: {
                listName,
                pItemsIds,
                taskName,
                pTaskParams: null
            },
            connection
        }, cacheConfig)
        return this.getBody(body)
    }

    /**
     * Initiate action under the specified file from specified network list.
     * @param {object} params
     * @param {string} params.listName - name of the network list.
     * @param {number} params.itemId - collection of the file identifiers. Each entry of the array is {number} params.identifier of the file. (see "nId" attribute from Quarantine, Backup, TIF lists)
     * @param {string} params.taskName - name of the action ["RestoreObj"	Restore object from quarantine/backup, "DeleteObj"	Delete object from quarantine/backup, "ScanQuarantine"	Scan object on quarantine/tif]
     * @param {Connection} connection
     * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
     * @deprecated pTaskParams	(params). Deprecated. May be empty but should be not null 
     * @returns 
     */
    async AddListItemTask ({listName, itemId, taskName}, connection, cacheConfig) {
        const body = await this.baseRequest({
            command: `${className}.AddListItemTask`,
            data: {
                listName,
                itemId,
                taskName,
                pTaskParams: null
            },
            connection
        }, cacheConfig)
        return this.getBody(body)
    }

    /**
     * Acquire info about specified file from specified network list.
     * @param {object} params
     * @param {any} params.itemId - identifier of the file. (see "nId" attribute from Quarantine, Backup, TIF lists)
     * @param {Connection} connection 
     * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
     * @returns 
     */
    async GetListItemInfo ({ itemId }, connection, cacheConfig) {
        const body = await this.baseRequest({
            command: `${className}.GetListItemInfo`,
            data: {
                itemId
            },
            connection
        }, cacheConfig)
        return this.getBody(body)
    }

}
