const BaseOpenAPIClient = require('../base-open-api-client')
const className = 'QueriesStorage'

module.exports = class QueriesStorage extends BaseOpenAPIClient {

  async GetQuery ({ nId }, connection, cacheConfig) {
    const body = await this.baseRequest({
      command: `${className}.GetQuery`,
      data: { nId: parseInt(nId) },
      connection
    }, cacheConfig)
    return this.getResult(body)
  }

  async GetQueryIds (eType, connection, cacheConfig) {
    const body = await this.baseRequest({
      command: `${className}.GetQueryIds`,
      data: { eType: parseInt(eType) },
      connection
    }, cacheConfig)
    return this.getResult(body)
  }

  async GetQueries (eType, connection, cacheConfig) {
    const body = await this.baseRequest({
      command: `${className}.GetQueries`,
      data: { eType: parseInt(eType) },
      connection
    }, cacheConfig)
    return this.getResult(body)
  }

  async DeleteQuery (nId, connection, cacheConfig) {
    const body = await this.baseRequest({
      command: `${className}.DeleteQuery`,
      data: { nId: parseInt(nId) },
      connection
    }, cacheConfig)
    return this.getBody(body)
  }

  async AddQuery ({ eType, query }, connection, cacheConfig) {
    const body = await this.baseRequest({
      command: `${className}.AddQuery`,
      data: {
        eType,
        parData: this.serialize(query),
      },
      connection
    }, cacheConfig)
    return this.getBody(body)
  }

  async UpdateQuery ({ nId, query }, connection, cacheConfig) {
    const body = await this.baseRequest({
      command: `${className}.UpdateQuery`,
      data: {
        nId: parseInt(nId),
        parData: this.serialize(query),
      },
      connection
    }, cacheConfig)
    return this.getBody(body)
  }

  async ExportQuery ({ nId }, connection, cacheConfig) {
    const body = await this.baseRequest({
      command: `${className}.ExportQuery`,
      data: {
        nId: parseInt(nId)
      },
      connection
    }, cacheConfig)
    return this.getResult(body)
  }

  async ImportQuery ({ eRequiredType, pData }, connection, cacheConfig) {
    const body = await this.baseRequest({
      command: `${className}.ImportQuery`,
      data: {
        eRequiredType,
        pData
      },
      connection
    }, cacheConfig)
    return this.getResult(body)
  }
}
