const BaseOpenAPIClient = require('../base-open-api-client')

/**
 * @deprecated should be moved to NWC server side
 */
module.exports = class Relations extends BaseOpenAPIClient {
  getRelationsBetweenAdmGrpRoles (filter = null, connection) {
    if (filter === null) {
      throw new Error('Error! id is null')
    }
    const OpenApiClient = require('../open-api-client')
    return OpenApiClient.HstAccessControl.FindTrusteesExtended({
      filters: filter,
      fields: [
        'KLHST_ACL_TRUSTEE_ID'
      ]
    }, connection)
    .then(respContainer => {
      const result = respContainer.result
      const filter = result.map(el => `(nTrusteeId = ${el.KLHST_ACL_TRUSTEE_ID})`)
      if (filter.length === 0) {
        return Promise.resolve({result: filter})
      }
      return OpenApiClient.SrvView.Fetch({
        wstrViewName: 'AdmGroupsAclRolesSrvViewName',
        wstrFilter: `(| ${filter})`,
        vecFieldsToReturn: [
          'nRoleId',
          'wstrRoleName',
          'wstrRoleDisplayName',
          'wstrTrusteeDisplayName',
          'wstrUserPrincipalName',
          'nGroupId',
          'wstrGroupName'
        ],
        all: 'all'
      }, connection)
    })
  }
  getRelationsBetweenAdmGrpRolesInternalUsers (nId, connection) {
    const filter = `(kscInternalUserId = ${nId})`
    return this.getRelationsBetweenAdmGrpRoles(filter, connection)
  }
  getRelationsBetweenAdmGrpRolesExternalUsers (objectGUID, connection) {
    const filter = `(objectGUID = "${objectGUID}")`
    return this.getRelationsBetweenAdmGrpRoles(filter, connection)
  }

  /**
   * Получение связей между ролями и польщователями (внутренними или внешними)
   * @param {object} params
   * @param {boolean} params.ul_InternalUser - флаг, является ли пользователь внутренним
   * @param {number} params.ul_nId - идентификатор внутреннего пользователя
   * @param {string} params.ul_strObjectGUID - идентификатор внешнего пользователя
   * @param {Connection} connection
   * @return {*}
   */
  getRelationsBetweenAdmGrpRolesUsers ({ ul_InternalUser, ul_nId, ul_strObjectGUID }, connection) {
    if (ul_InternalUser) {
      return this.getRelationsBetweenAdmGrpRolesInternalUsers(ul_nId, connection)
    } else {
      return this.getRelationsBetweenAdmGrpRolesExternalUsers(ul_strObjectGUID, connection)
    }
  }
}
