const BaseOpenAPIClient = require('../base-open-api-client')

module.exports = class Request extends BaseOpenAPIClient {
  async send (props, connection, cacheConfig) {
    const body = await this.baseRequest({
      ...props,
      connection,
      raw: true
    }, cacheConfig)
    return this.getBody(body)
  }

  async downloadFile ({ url, asBase64, asString }, connection, cacheConfig) {
    const { result: file } = await this.send({
      url,
      httpMethod: 'GET'
    }, connection, cacheConfig)
    return {
      result: asBase64
        ? file.toString('base64')
        : asString
          ? file.toString()
          : file
    }
  }
}
