const BaseOpenAPIClient = require('../base-open-api-client')
const className = 'ScanDiapasons'

module.exports = class ScanDiapasons extends BaseOpenAPIClient {
  GetDiapasons ({ vecFieldsToReturn = [
    'KLDPNS_ID',
    'KLDPNS_DN',
    'KLDPNS_LF',
    'KLDPNS_ScanEnabled',
    'KLDPNS_ILS'
  ], lMaxLifeTime = 7200 }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.GetDiapasons`,
      data: { vecFieldsToReturn, lMaxLifeTime },
      connection
    }, cacheConfig)
               .then(body => this.deserialize(body, 'PxgRetVal'))
  }

  GetDiapason ({idDiapason = 1, pFields = [
    'KLDPNS_ID',
    'KLDPNS_DN',
    'KLDPNS_LF',
    'KLDPNS_ScanEnabled',
    'KLDPNS_ILS'
  ]} = {}, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.GetDiapason`,
      data: { idDiapason, pFields },
      connection
    }, cacheConfig)
      .then(body => this.deserialize(body, 'PxgRetVal'))
  }

  UpdateDiapason ({
    idDiapason,
    pInfo
  } = {}, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.UpdateDiapason`,
      data: { idDiapason, pInfo },
      connection
    }, cacheConfig)
      .then(body => this.deserialize(body, 'pInvalidIntervals'))
  }
  
  RemoveDiapason ({ idDiapason }, connection, cacheConfig ) {
    return this.baseRequest({
      command: `${className}.RemoveDiapason`,
      data: {idDiapason},
      connection
    }, cacheConfig)
      .then(this.getBody)
  }
  
  AddDiapason ({ pInfo }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.AddDiapason`,
      data: pInfo,
      connection
    }, cacheConfig)
      .then(this.getBody)
  }
}
