const BaseOpenAPIClient = require('../base-open-api-client')
const className = 'ServiceNwcCommandProvider'

module.exports = class ServiceNwcCommandProvider extends BaseOpenAPIClient {
  /**
   * Get command payload
   * @param {object} params
   * @param {string} params.wstrCommandId - command id
   * @param {*} connection
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @returns {Promise<Object>}
   */
  async GetCommandPayload ({ wstrCommandId }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.GetCommandPayload`,
      data: { wstrCommandId },
      connection
    }, cacheConfig).then(this.getBody)
  }

  /**
   * Notify about command processing error
   * @param {object} params
   * @param {string} params.wstrCommandId - command id
   * @param {object} params.pError - error description
   * @param {*} connection
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   */
  async SetCommandError ({ wstrCommandId, pError }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.SetCommandError`,
      data: { wstrCommandId, pError },
      connection
    }, cacheConfig).then(this.getResult)
  }

  /**
   * Set command result
   * @param {object} params
   * @param {string} params.wstrCommandId - command id
   * @param {object} params.pResult - result of command
   * @param {*} connection
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   */
  async SetCommandResult ({ wstrCommandId, pResult }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.SetCommandResult`,
      data: { wstrCommandId, pResult },
      connection
    }, cacheConfig).then(this.getResult)
  }
}
