const BaseOpenAPIClient = require('../base-open-api-client')
const className = 'ServiceNwcDeployment'

module.exports = class ServiceNwcDeployment extends BaseOpenAPIClient {
  /**
    * Create NWC Service Account
    * @param {null} params - this method doesn't receive any params
    * @param {*} connection
    * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
    * @returns {Promise<Object>}
    */
  async CreateServiceAccount (params = null, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.CreateServiceAccount`,
      connection
    }, cacheConfig).then(this.getBody)
  }

  /**
   * Modify ACL of all security groups and virtual servers for specified Service Account
   * @param {object} params
   * @param {object} params.pAclParams - acl
   * @param {*} connection
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @returns {Promise<Object>}
   */
  async UpdateServiceAccountAcl ({ pAclParams }, connection, cacheConfig) {
    const params = { pAclParams: this.serialize(pAclParams) }
    return this.baseRequest({
      command: `${className}.UpdateServiceAccountAcl`,
      data: params,
      connection
    }, cacheConfig).then(this.getBody)
  }
}
