const baseOpenAPIClient = require('../base-open-api-client')
const prepareAuthHeaders = require('../../helpers/auth-headers')
const className = 'Session'

module.exports = class Session extends baseOpenAPIClient {
  /**
   * Creates session token
   * Creates session token for current security context. Those token can be used for logon purposes to Administaration Server for a short time (3 minutes by default)
   */
  CreateToken (noParams, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.CreateToken`,
      connection
    }, cacheConfig).then(this.getResult)
  }

  StartSession (params, connection, cacheConfig) {
    const headers = prepareAuthHeaders(params)
    return this.baseRequest({
      command: `${className}.StartSession`,
      headers,
      connection
    }, cacheConfig)
  }

  EndSession (_, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.EndSession`,
      connection
    }, cacheConfig)
  }

  Ping (_, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.Ping`,
      connection
    }, cacheConfig).then(this.getBody)
  }

  CreateBlob ({
    KLCST_TARGET_PORT,
    KLCST_LOCATIONS,
    KLCST_USER_COMMAND,
    KLCST_TARGET_HOST_NAME,
    KLCST_RDS_TICKET,
    KLCST_RDS_PASSWORD
  },
  connection,
  cacheConfig
  ) {
    return this.baseRequest({
      command: `${className}.CreateBlob`,
      data: {
        pParams: this.serialize({
          KLCST_TARGET_PORT,
          KLCST_LOCATIONS,
          KLCST_USER_COMMAND,
          KLCST_TARGET_HOST_NAME,
          KLCST_RDS_TICKET,
          KLCST_RDS_PASSWORD
        })
      },
      connection
    }, cacheConfig).then(this.getResult)
  }
}
