const BaseOpenAPIClient = require('../base-open-api-client')
const className = 'SiemExport'

module.exports = class SiemExport extends BaseOpenAPIClient {
  /**
   * Set SIEM export settings.
   * @param {object} pParams - SIEM settings
   * @param {Connection} connection - Connection instance
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @returns {Promise}
   */
  SetSiemSettings ({ pParams }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.SetSiemSettings`,
      data: { pParams },
      connection
    }, cacheConfig).then(this.getBody)
  }

  /**
   * Get SIEM export settings.
   * @param {null} _ - Null-argument, not used in method
   * @param {Connection} connection - Connection instance
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @returns {Promise}
   */
  GetSiemSettings (_, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.GetSiemSettings`,
      data: null,
      connection
    }, cacheConfig).then(this.getResult)
  }
}
