const BaseOpenAPIClient = require('../base-open-api-client')
const className = 'SpamEvents'

module.exports = class SpamEvents extends BaseOpenAPIClient {
  /**
   * Return array of SPAM events
   * @param {null} params - this method doesn't receive any params
   * @param {*} connection
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @returns [array] - each element of array contains information about SPAM events
   */
  async GetSpamList (params = null, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.GetSpamList`,
      connection
    }, cacheConfig).then(this.getResult)
  }

  /**
   * Remove SPAM events with some id's
   *
   * @param {object} params
   * @param {Array} params.pArraySpamEventIds - array of SPAM-events identifiers
   * @param {*} connection
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   */
  async RemoveFromSpamList ({ pArraySpamEventIds }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.RemoveFromSpamList`,
      data: { pArraySpamEventIds },
      connection
    }, cacheConfig).then(this.getResult)
  }

  /**
   * Remove SPAM-event from the exclusion list
   *
   * @param {object} params
   * @param {Array} params.pArraySpamEventIds - array of SPAM-events identifiers
   * @param {*} connection
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   */
  async RemoveFromExclusion ({ pArraySpamEventIds }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.RemoveFromExclusion`,
      data: { pArraySpamEventIds },
      connection
    }, cacheConfig).then(this.getResult)
  }

  /**
   * Add SPAM-event to the exclusion list
   *
   * @param {object} params
   * @param {Array} params.pArraySpamEventIds - array of SPAM-events identifiers
   * @param {*} connection
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   */
  async AddToExclusion ({ pArraySpamEventIds }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.AddToExclusion`,
      data: { pArraySpamEventIds },
      connection
    }, cacheConfig).then(this.getResult)
  }
}
