const BaseOpenAPIClient = require('../base-open-api-client')
const className = 'SrvCloudStat'

/**
 * @class
 * @classdesc Interface for working with statistics of using clouds.
 * @extends BaseOpenAPIClient
 */
module.exports = class SrvCloudStat extends BaseOpenAPIClient {
  /**
   * @method
   * @description Notify that the Cloud Wizard has been started.
   * @param {{ pParams: null }} params - object containing function arguments. Consists of:
   * – pParams – For additional options. Reserved.
   * @param {Connection} connection – Connection object.
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @returns {void} no value to return, no error means request completed successfully
   */
  async CloudWizardStarted ({ pParams = null }, connection, cacheConfig) {
    const body = await this.baseRequest({
      command: `${className}.CloudWizardStarted`,
      data: { pParams: this.serialize(pParams) },
      connection
    }, cacheConfig)

    return this.getResult(body)
  }

  /**
   * @method
   * @description Notify that the Cloud Wizard has been completed. Method shouldn't be called if user cancelled the wizard.
   * @param {{ bErrorHappen: boolean, pParams: null }} params - object containing function
   * arguments. Consists of:
   * - bErrorHappen - true if error was happen. false if wizard has been completed successfully.
   * - pParams - NULL falue as it used for additional options. Reserved
   * @param {Connection} connection - Connection object.
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @returns {void} no value to return, no error means request completed successfully
   */
  async CloudWizardCompleted ({ bErrorHappen, pParams = null }, connection, cacheConfig) {
    const body = await this.baseRequest({
      command: `${className}.CloudWizardCompleted`,
      data: {
        bErrorHappen,
        pParams: this.serialize(pParams)
      },
      connection
    }, cacheConfig)

    return this.getResult(body)
  }
}
