const BaseOpenAPIClient = require('../base-open-api-client')
const className = 'SrvCloud'

/**
 * @class
 * @classdesc Interface to acquire info about public clouds.
 * @extends BaseOpenAPIClient
 */
module.exports = class SrvCloud extends BaseOpenAPIClient {
  async GetCloudsInfo ({
    pParams = null
  }, connection, cacheConfig) {
    const body = await this.baseRequest({
      command: `${className}.GetCloudsInfo`,
      data: this.serialize({ pParams }),
      connection
    }, cacheConfig)
    return this.deserialize(body, 'PxgRetVal')
  }

  /**
   * @method
   * @description Returns properties of the cloud host.
   * @param {{ pCloudHostBinId: String, pFields: Object, pParams: null }} params - object containing function
   * arguments. Consists of:
   * - CloudHostBinId - internal id of the cloud host (binary in terms of OpenAPI)
   * - pFields - collection of cloud host attribute names that need to return
   * - pParams - NULL falue as it used for additional options. Reserved
   * @param {Connection} connection - Connection object.
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @returns {object} ppHostInfo - list of founded attributes that are specified in arrFields
   */
  async GetCloudHostInfo ({
    pCloudHostBinId,
    pFields,
    pParams = null
  }, connection, cacheConfig) {
    const body = await this.baseRequest({
      command: `${className}.GetCloudHostInfo`,
      data: this.serialize({
        pCloudHostBinId,
        pFields,
        pParams
      }),
      connection
    }, cacheConfig)
    return this.deserialize(body, 'PxgRetVal')
  }
}
