const BaseOpenAPIClient = require('../base-open-api-client')
const className = 'SrvIpmNewsAndStatistics'

module.exports = class SrvIpmNewsAndStatistics extends BaseOpenAPIClient {
  SendStatistics ({ pwchContentId }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.SendStatistics`,
      data: {
        pwchContentId
      },
      connection
    }, cacheConfig).then(this.getBody)
  }

  /**
   * @method
   * @description Gets tracking data for specified content.
   * @param {{ pwchContentId: string }} params - object containing function arguments. Consists of:
   * – pwchContentId – Content id from c_szwContentId. If empty KSC server's tracking data will be returned
   * @param {Connection} connection – Connection object.
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @returns {any} Returns array of params, each element contains:
   * – LicenseId - License Id (paramString)
   * – ApplicationId - Application Id (paramInt)
   * – ApplicationVersion - Application version (paramString)
   * – Localization - Localization in ISO639 (paramString)
   * – LtsId - Lts Id (paramString)
   * – HardwareId - Hardware Id (paramString)
   */
  GetTrackingData ({ pwchContentId }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.GetTrackingData`,
      data: {
        pwchContentId
      },
      connection
    }, cacheConfig).then(this.getResult)
  }
}
