const BaseOpenAPIClient = require('../base-open-api-client')
const className = 'SrvRi'

module.exports = class SrvRi extends BaseOpenAPIClient {
  /**
   *
   * @param pHostsArray - Array<{ KLRI_SRVRI_HOST_ID: string }>
   *   KLRI_SRVRI_HOST_ID - Host ID
   * @param connection
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @returns {Promise<*>}
   */
  async SetRebootConfirmedHosts ({
    pHostsArray
  }, connection, cacheConfig) {
    const body = await this.baseRequest({
      command: `${className}.SetRebootConfirmedHosts`,
      data: this.serialize({ pHostsArray }),
      connection
    }, cacheConfig)

    return this.deserialize(body, 'PxgRetVal')
  }
}
