const BaseOpenAPIClient = require('../base-open-api-client')
const className = 'SubnetMasks'

module.exports = class SubnetMasks extends BaseOpenAPIClient {

  CreateSubnet ({ pSubnetSettings }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.CreateSubnet`,
      data: { pSubnetSettings },
      connection
    }, cacheConfig)
      .then(this.getBody)
  }

  DeleteSubnet ({ nIpAddress, nMask }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.DeleteSubnet`,
      data: { nIpAddress, nMask },
      connection
    }, cacheConfig)
      .then(this.getBody)
  }

  ModifySubnet ({ nIpAddress, nMask, pSubnetSettings }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.ModifySubnet`,
      data: {
        pSubnetSettings,
        nIpAddress,
        nMask
      },
      connection
    }, cacheConfig)
      .then(this.getBody)
  }

}
