const BaseOpenAPIClient = require('../base-open-api-client')
const className = 'TotpUserSettings'

module.exports = class TotpUserSettings extends BaseOpenAPIClient {
  /**
   * Add/remove user to/from exceptions list of "2FA is required for all users" requirement.
   *
   * @param {object} llTrusteeId - Trustee id to change settings
   * @param {Boolean} bInExceptions - True - add user to exceptions, false - exclude from exceptions
   * @param {*} connection
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   */
  async AddUserToTotpRequrementExceptions ({ llTrusteeId, bInExceptions }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.AddUserToTotpRequrementExceptions`,
      data: {
        bInExceptions,
        llTrusteeId
      },
      connection
    }, cacheConfig).then(this.getResult)
  }

  /**
   * Clear TOTP secret for user (spl_users, ak_users only)
   *
   * @param {object} llTrusteeId - Trustee id to change settings
   * @param {*} connection
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   */
  async ClearUserSecret ({ llTrusteeId }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.ClearUserSecret`,
      data: { llTrusteeId },
      connection
    }, cacheConfig).then(this.getResult)
  }
}
