const BaseOpenAPIClient = require('../base-open-api-client')
const className = 'UaControl'

module.exports = class UaControl extends BaseOpenAPIClient {
  /**
   * GetUpdateAgentsDisplayInfoForHost
   * @param {object} params
   * @param {string} params.wstrHostId - Host id to find UAs
   * @param {Connection} connection
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @return {Promise.<object>}
   * @constructor
   */
  GetUpdateAgentsDisplayInfoForHost ({ wstrHostId }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.GetUpdateAgentsDisplayInfoForHost`,
      data: { wstrHostId },
      connection
    }, cacheConfig)
      .then(body => this.getResult(body, 'pUaInfo'))
  }

  GetAssignUasAutomatically (data = {}, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.GetAssignUasAutomatically`,
      connection
    }, cacheConfig)
      .then(this.getResult)
  }

  GetDefaultUpdateAgentRegistrationInfo (data = {}, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.GetDefaultUpdateAgentRegistrationInfo`,
      connection
    }, cacheConfig)
      .then(body => this.getResult(body, 'pUaInfo'))
  }

  GetUpdateAgentsList (data = {}, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.GetUpdateAgentsList`,
      connection
    }, cacheConfig)
      .then(body => this.deserialize(body, 'pUasArr'))
  }

  ModifyUpdateAgent ({ pUaInfo }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.ModifyUpdateAgent`,
      data: {
        pUaInfo: this.serialize(pUaInfo)
      },
      connection
    }, cacheConfig)
      .then(this.getResult)
  }

  GetUpdateAgentInfo ({ wstrUaHostId }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.GetUpdateAgentInfo`,
      data: {
        wstrUaHostId
      },
      connection
    }, cacheConfig)
      .then(body => this.getResult(body, 'pUaInfo'))
  }

  RegisterDmzGateway ({ pCgInfo }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.RegisterDmzGateway`,
      data: {
        pCgInfo
      },
      connection
    }, cacheConfig)
      .then(this.getResult)
  }

  RegisterUpdateAgent ({ pUaInfo }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.RegisterUpdateAgent`,
      data: {
        pUaInfo: this.serialize(pUaInfo)
      },
      connection
    }, cacheConfig)
      .then(this.getResult)
  }

  SetAssignUasAutomatically ({ bEnabled }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.SetAssignUasAutomatically`,
      data: {
        bEnabled
      },
      connection
    }, cacheConfig)
      .then(this.getResult)
  }

  UnregisterUpdateAgent ({ wstrUaHostId }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.UnregisterUpdateAgent`,
      data: {
        wstrUaHostId
      },
      connection
    }, cacheConfig)
      .then(this.getResult)
  }
}
