const BaseOpenAPIClient = require('../base-open-api-client')
const className = 'UpdComps'

module.exports = class UpdComps extends BaseOpenAPIClient {
  /**
   * @obsolete
   * Requests asynchronous bases update
   * @param pParams -  Update operation parameters
   * @param wsRequestId - Unique user-generated request identifier of new asynchronous update operation
   * @param connection
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @returns {Promise.<object>}
   * @constructor
   */
  UpdateAsync ({ pParams, wsRequestId }, connection, cacheConfig) {
    return this.baseRequest({ command: `${className}.UpdateAsync`, data: { pParams, wsRequestId }, connection }, cacheConfig)
      .then(this.getResult)
  }

  /**
   * Stops operation by request
   * @param wsRequestId - Unique user-generated request identifier of new asynchronous update operation
   * @param bWait - Whether to wait for actual operation stop in blocking way (true) or just initiate asynchronous stop and return back ASAP (false)
   * @param connection
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @returns {Promise.<object>}
   * @constructor
   */
  Stop ({ wsRequestId, bWait }, connection, cacheConfig) {
    return this.baseRequest({ command: `${className}.Stop`, data: { wsRequestId, bWait }, connection }, cacheConfig)
      .then(this.getResult)
  }

  /**
   * Requests asynchronous bases update or retranslation
   * @param pParams - Update operation parameters
   * @param connection
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @returns {Promise.<string>} - Unique auto-generated request identifier of new asynchronous update operation (GUID).
   * @constructor
   */
  AsyncUpdate ({ pParams }, connection, cacheConfig) {
    return this.baseRequest({ command: `${className}.AsyncUpdate`, data: { pParams }, connection }, cacheConfig)
      .then(this.getResult)
  }
}
