const BaseOpenAPIClient = require('../base-open-api-client')
const className = 'Updates'
const _ = require('lodash')

module.exports = class Updates extends BaseOpenAPIClient {
  GetUpdatesInfo ({pFilter}, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.GetUpdatesInfo`,
      connection,
      data: {
        pFilter
      }
    }, cacheConfig)
      .then(this.deserialize)
  }

  GetAvailableUpdatesInfo ({ strLocalization, pAvailableUpdateComps, pAvailableUpdateApps } = {}, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.GetAvailableUpdatesInfo`,
      data: { strLocalization, pAvailableUpdateComps, pAvailableUpdateApps },
      connection
    }, cacheConfig).then(resp => {
      let { pAvailableUpdateComps, pAvailableUpdateApps } = resp.body
      let result = []
      if (_.isEmpty(pAvailableUpdateComps) && _.isEmpty(pAvailableUpdateApps)) {
        return result
      }
      let collectUpdatesAndApps = (updates) => {
        result = result.concat(_.reject(_.map(updates, update => update.value), update => !update.Name))
      }
      _.forEach(pAvailableUpdateComps, collectUpdatesAndApps)
      _.forEach(pAvailableUpdateApps, collectUpdatesAndApps)
      return result
    })
  }
}
