const BaseOpenAPIClient = require('../base-open-api-client')
const className = 'VServers2'

module.exports = class VServers2 extends BaseOpenAPIClient {
  /**
   * Acquire info on virtual server
   * @param {object} vServer
   * @param {number} vServer.lVsId virtual server id, value 0 results in returning data about hosts connected directly to the physical server (VS0)
   * @param {CacheConfig} cacheConfig - config of LRU caching, can be used for enabling request method caching
   * @returns {Promise.<object>} - Returns info about the specified virtual server
   */
  GetVServerStatistic ({ lVsId }, connection, cacheConfig) {
    return this.baseRequest({
      command: `${className}.GetVServerStatistic`,
      data: {
        lVsId
      },
      connection
    }, cacheConfig)
      .then(this.deserialize)
  }
}
