class OpenApiClassLogger {
  constructor (skipMethods) {
    this.skipMethods = skipMethods
  }

  shouldSkip (command) {
    if (typeof command !== 'string') return false
    const [, methodName] = command.split(/[.?]+/)
    return this.skipMethods.includes(methodName)
  }

  log (command, ...messageItems) {
    if (this.shouldSkip(command)) return
    runtime.logger.log(...messageItems)
  }

  info (command, ...messageItems) {
    if (this.shouldSkip(command)) return
    runtime.logger.info(...messageItems)
  }

  warn (...messageItems) {
    runtime.logger.warn(...messageItems)
  }

  error (...messageItems) {
    runtime.logger.error(...messageItems)
  }
}

module.exports = OpenApiClassLogger
