const getConnectionInfo = (connection) => {
  if (!connection) return null

  return {
    connection: {
      ...connection.uid && { uid: connection.uid },
      ...connection.clientUid && { clientUid: connection.clientUid },
      ...connection.wsId && { wsId: connection.wsId },
      ...connection.hostedInstanceId && { hostedInstanceId: connection.hostedInstanceId }
    }
  }
}

const getRequestPath = ({ connection, url, command }) => url || `/api/${connection.config.openAPIVersion}/${command}`

module.exports = { getConnectionInfo, getRequestPath }
