const BaseOpenAPIClient = require('../base-open-api-client')
const connectionPool = require('../../connection-pool/connection-pool')
const PermanentConnection = require('../../connection-pool/permanent-connection')
const { OK_STATUS } = require('../../constants/ksc-status-codes')

class SecondFactorRegistrationUtils extends BaseOpenAPIClient {
  async createConnection ({
    openAPIHost, openAPIPort, openAPIVersion
  }) {
    const connectionId = await connectionPool.createConnection({
      openAPIHost,
      openAPIPort,
      openAPIVersion,
      handshakeFunc: () => {
        return {
          response: { statusCode: OK_STATUS }
        }
      }
    }, PermanentConnection)

    return connectionPool.getConnection(connectionId)
  }

  async getSecret (connectionOptions) {
    return this.makeRequest(connectionOptions, 'TotpRegistration.GenerateSecret')
  }

  async register(connectionOptions, { secretId, securityCode }) {
    const data = {
      wstrSecretId: secretId,
      wstrValidationCode: securityCode
    }
    return this.makeRequest(connectionOptions, 'TotpRegistration.SaveSecretForCurrentUser', data)
  }

  async makeRequest({ openAPIHost, openAPIPort, openAPIVersion, kscSessionCode, connectionId }, command, data) {
    let connection
    if (connectionId) {
      connection = connectionPool.getConnection(connectionId)
    } else {
      connection = await this.createConnection({
        openAPIHost,
        openAPIPort,
        openAPIVersion
      })
    }

    return new Promise(async (resolve, reject) => {
      const headers = {
        'Content-Type': 'application/json'
      }
      if (kscSessionCode) {
        headers['X-KSC-Session'] = kscSessionCode
      } else {
        headers['Connection'] = 'keep-alive'
      }
      const requestData = {
        connection,
        headers,
        command
      }
      if (data) {
        requestData.data = data
      }
      const result = await this.request(
        requestData,
        resolve,
        reject
      )
      if (!connectionId) {
        connection.close()
      }
      return result
    })
  }
}

module.exports = new SecondFactorRegistrationUtils()
