type VecField = {
    Name: string,
    Asc: boolean | 'true' | 'false'
}

export type VecFieldToOrder = VecField | {
    type: string,
    value: VecField
}

export type scalar = string | boolean | number;

export type ParamDateTime = {
    readonly type: 'datetime',
    value: string
}

export type ParamLong = {
    readonly type: 'long',
    value: string
}

export type ParamBinary = {
    readonly type: 'binary',
    value: string
}

export type ParamParams<T = Params> = {
    readonly type: 'params',
    value: T
}

type ParamWrapped<T> = {
    readonly type: string,
    value: T
}

export type ParamValue = scalar | ParamWrapped<scalar> | Params;

export type Params = {
    [prop: string]: ParamValue | ParamValue[]
}

export type OpenAPIIterator<T = any> = {
    getItems: (count?: number) => Promise<T[]>,
    count: () => Promise<number>,
    close: () => Promise<void>,
    next: () => Promise<T>,
    prev: () => Promise<T>,
    setPageSize: (size: number) => Promise<void>,
    getPageCount: () => Promise<number>,
    setPosition: (pos: number) => void,
    getPosition: () => number,
    PxgRetVal: any
}

export enum ObjectTypes {
    Administration_group = 1,
    Task = 2,
    Report = 3,
    Package = 4,
    Queries = 5,
    Licenses = 6
}
