import { ParamBinary, ParamDateTime } from './common'

export type LicenseKey = {
    KLLIC_APP_ID: number, // 'Primary' Application ID
    /*
          Application IDs and licensed objects. Each entry is also paramParams container which has name based on the
          ApplicationID (for example' '1017', '1105') and contains KLLIC_APP_ID and values KLLIC_LICOBJECT_* inside.
          See Description of the KLLIC_APP_IDS format.
       */
    KLLIC_APP_IDS?: {
        [appId: number]: {
            KLLIC_APP_ID: number, // Application ID in the numeric form
            /*
                      Name of this attribute contains value of the licensed object ID (num). The value this attribute
                      contains the limitation ('licenses count') for the licensed object 'num'.
                   */
            [licobject: string]: number
        }
    },
    KLLIC_PROD_SUITE_ID: number, // Product suite id
    KLLIC_CREATION_DATE: ParamDateTime, // License key creation time
    KLLIC_LIMIT_DATE: ParamDateTime, // License key limit expiration time
    /*
          License key file (or Activation 1.0 license), its serial number looks looks like 'E2C-0006D6-5096F7FF'
          and has length less than 32 characters;

          Activation 2.0 license, it doesn't have a key file at all, and its serial number looks like
          E57CF700FFAB4143BB6E9E0B88AAE4FF and has length strictly 32 characters.
       */
    KLLIC_SERIAL: string,
    KLLIC_PROD_NAME: string, // License key name
    KLLIC_KEY_TYPE: KeyType, // License key type
    KLLIC_MAJ_VER: string, // Major version
    KLLIC_LICENSE_PERIOD: number, // License key validity period, in days, must be ignored for Subscription licenses
    KLLIC_LIC_COUNT: number, // Number of licenses
    KLLIC_LICINFO: string, // License information
    KLLIC_SUPPORT_INFO: string, // Support information
    KLLIC_CUSTOMER_INFO: string, // Customer information
    KLLIC_NHOSTS_ASCURRENT: number, // Number of hosts where key is installed as 'current key'
    KLLIC_NHOSTS_ASNEXT: number, // Number of hosts where key is installed as 'next key'
    KLLICSRV_KEY_INSTALLED: boolean, // True if key is installed into server-side license storage, false otherwise
    KLLICSRV_AUTOKEY: boolean, // True if license can be deployed automatically, false otherwise
    KLLIC_LICTYPE_IS_SUBSCRIPTION: boolean, // True if license is of type 'Subscription', otherwise false
    // Indicates date when subscription expires or enters into the grace period
    KLLIC_SUBSCRINFO_ENDDATE: ParamDateTime,
    KLLIC_SUBSCRINFO_ENDDATETYPE: number, // Indicates type of subscription end date
    // Period of time (in days) that indicates how much time subscription user has to renew his subscription
    KLLIC_SUBSCRINFO_GRACETERM: number,
    KLLIC_SUBSCRINFO_PROVIDERURL: string, // Value indicates URL to subscription provider web page
    KLLIC_SUBSCRINFO_STATE: any // Field indicates current subscription state
}

export type LicenseKeyData = LicenseKey & {
  /*
        Key data, contains fields KLLIC_LICFILE (required) and KLLIC_CUSTOMER_INFO (optional).
        This attribute cannot be acquired while enumerating license keys.
     */
  KLLICSRV_KEYDATA?: {
    KLLIC_IFKEYFILE: boolean,
    KLLIC_LICFILE: ParamBinary,
    KLLIC_CUSTOMER_INFO?: any
  },
  [licobject: string]: any
}
