import { ParamDateTime } from './common'

type TaskAttributes = {
    TASK_NAME: string,
    DisplayName: string,
    TASK_UNIQUE_ID: string,
    PRTS_TASK_CREATION_DATE: string,
    TASKID_PRODUCT_NAME: string,
    TASKID_VERSION: string
}

type TaskRequiredSettings = {
    TASKID_COMPONENT_NAME: string,
    TASKID_PRODUCT_NAME: string,
    TASKID_VERSION: string,
    TASK_NAME: string,
    DisplayName: string,
    'TASK_ADDITIONAL_PARAMS': any,
    'TASK_INFO_PARAMS':	any,
    TASKSCH_TYPE: number,
    'klprts-TaskScheduleSubtype': number
}

type TaskConditionKeys = 'KLPRTS_START_CONDITION_VALUE' | 'KLPRTS_START_CONDITION_VALUE2' | 'KLPRTS_START_CONDITION_VALUE_EX'
    | 'KLPRTS_START_CONDITION_TYPE';

type TaskOptionalSettings = Partial<{
    KLPRCI_TASK_INVISIBLE: boolean,
    KLPRTS_START_CONDITION: Record<TaskConditionKeys, number | string>,
    TASK_DEL_AFTER_RUN_FLAG: boolean,
    PRTS_TASK_GROUPID: number,
    PRTS_EXCEPT_GROUPIDS: number[],
    KLHST_WKS_CTYPE: number,
    /*
        Target computer types. May have the following values:

        1 Add workstations to the task scope.
        2 Add servers to the task scope.
        3 Add both servers and workstations to the task scope.
        Contained in 'TASK_INFO_PARAMS'.
    */

    '.HstQueryId': number,
    HostList: any[],
    'KLPRSS_EVPNotifications': Record<'INF' | 'WRN' | 'ERR' | 'CRT', Record<string, any>[]>,
    KLTSK_ALLOW_AUTO_RANDOMIZATION: boolean,
    TASK_START_DELTA: number,
    TASKSCH_RUN_MISSED_FLAG: boolean,
    'klprts-WakeOnLAN': number,
    'klprts-ShutdownSystemAfterRun': boolean,
    'klprts-TaskMaxRunningTime': number,
    'klprts-TaskCannotBeDeleted': boolean,
    'TASKSCH_FIRST_EXECUTION_TIME': string,
    TASKSCH_FIRST_EXECUTION_TIME_SEC: number,
    TASK_PRIORITY: number,
    'TASKSCH_LIFETIME': string,
    TASK_MAX_EXEC_TIME: ParamDateTime,
    'TASK_LAST_EXEC_TIME': string,
    TASK_LAST_EXEC_TIME_SEC: number,
    TASK_PREP_START: number,
    TASKSCH_MS_PERIOD: number,
    TASKSCH_ED_HOURS: number,
    TASKSCH_ED_MINS: number,
    TASKSCH_ED_SECS: number,
    TASKSCH_EW_DAY: number,
    TASKSCH_EW_HOURS: number,
    TASKSCH_EW_MINS: number,
    TASKSCH_EW_SECS: number,
    TASKSCH_EM_DAY: number,
    TASKSCH_EM_HOURS: number,
    TASKSCH_EM_MINS: number,
    TASKSCH_EM_SECS: number,
    PRTS_TASK_TARGET_COMPUTERS_TYPE: number,
    /*    Type of managed devices. Auxiliary parameter used in GUI only. Contained in 'TASK_INFO_PARAMS'. Possible values:

            0 - Managed devices scanned by KSC
        1 - Managed devices addresses provided by the user
        2 - KSC's device query
        3 - Administration group
        Defaults: If PRTS_TASK_GROUPID == -1 then default value is 0, otherwise - 3 */

    PRTS_TASK_GROUPNAME: string,
    'klprts-DontApplyToSlaveServers': boolean,
    'klprts-TaskAccountUser': string,
    'klprts-TaskAccountPassword': string
}>;

export type TaskSettings = TaskRequiredSettings & TaskOptionalSettings;

export type TaskStats = {
    '1': number,
    '2': number,
    '4': number,
    '8': number,
    '16': number,
    '32': number,
    '64': number,
    'KLTSK_NEED_RBT_CNT': number,
    'GNRL_COMPLETED_PERCENT': number,
    'KLTSK_VIRT_PRGS': boolean,
    'KLTSK_ERR_REASONS_CNT': unknown
}

type TaskAdditionalParams = {
    CompatibilityInfo?: {
        MinimalPluginVersion: string
    },
    PRTS_TASK_EXT_SHEDULE_FLAGS?: number,
    [prop: string]: any
}

export type TaskData<T extends object = Record<string, any>> = {
    readonly EVENT_TYPE: string,
    readonly FILTER_EVENTS_COMPONENT_NAME: string,
    readonly FILTER_EVENTS_INSTANCE_ID: string,
    readonly FILTER_EVENTS_PRODUCT_NAME: string,
    readonly FILTER_EVENTS_VERSION: string,
    readonly TASKID_COMPONENT_NAME: string,
    readonly TASKID_INSTANCE_ID?: string,
    readonly TASKID_PRODUCT_NAME: string,
    readonly TASKID_VERSION: string,
    readonly TASKSCH_FIRST_EXECUTION_TIME?: ParamDateTime,
    readonly TASKSCH_FIRST_EXECUTION_TIME_SEC?: number,
    readonly TASKSCH_LIFETIME?: ParamDateTime,
    readonly TASKSCH_MS_PERIOD?: number,
    readonly TASKSCH_RUN_MISSED_FLAG?: boolean,
    readonly TASKSCH_TYPE: number,
    TASK_ADDITIONAL_PARAMS: T & TaskAdditionalParams,
    readonly TASK_CLASS_ID?: number,
    readonly TASK_DEL_AFTER_RUN_FLAG?: boolean,
    readonly TASK_INFO_PARAMS: {
        DisplayName: string,
        [prop: string]: any
    },
    readonly TASK_LAST_EXEC_TIME?: ParamDateTime,
    readonly TASK_LAST_EXEC_TIME_SEC?: number,
    readonly TASK_MAX_EXEC_TIME?: number,
    readonly TASK_NAME: string,
    readonly TASK_PREP_START?: number,
    readonly TASK_PRIORITY?: number,
    readonly TASK_START_DELTA?: number,
    readonly TASK_UNIQUE_ID?: string
}
