export type Connection = {
    customHeaders: unknown[],
    options: unknown[],
    config: {
        openAPIHost: string, openAPIPort: string
    }
};
export function download({
  path, method, chunkSize, onChunkRecieved, contentLength: predefinedLength,
  connection: {
    customHeaders, options,
    config: {
      openAPIHost, openAPIPort
    }
  }
}: {
    path: string,
    method?: string,
    chunkSize?: number,
    onChunkRecieved: ({ response: ServerResponse, contentLength: number, chunk: Buffer }: {
        response: unknown,
        contentLength: unknown,
        chunk: unknown
    }) => {},
    contentLength?: number,
    connection: Connection
}): Promise<void>;
export function uploadFilePart({ chunk, from, to, path, fullFileLength }: {
    chunk: string,
    from: number,
    to: number,
    path: string,
    fullFileLength: number
}, connection: Connection): Promise<unknown>;
export function upload({ url, fileString, remainingFileLength }: {
    url: string,
    fileString: string,
    remainingFileLength: number
}, connection: Connection): Promise<void>;
