import { OpenAPIClient } from './types'
import ConnectionPool = require('./connection-pool/connection-pool')
import OpenAPIServerTransport = require('./transport/server-transport')
import OpenAPIHelpers = require('./helpers/index')
import Init = require('./open-api-client/init')
import GetConnConstructor = require('./connection-pool/get-connection-constructor')

declare const instance: {
    connectionPool: ConnectionPool,
    openAPIClient: OpenAPIClient,
    transport: {
        OpenAPIServerTransport: OpenAPIServerTransport
    },
    helpers: typeof OpenAPIHelpers,
    init: typeof Init,
    getConnectionConstructorByAuthType: typeof GetConnConstructor
}
export = instance
