import { CacheConfig, Connection } from '../types'

type RequestParams = {
    command: string,
    httpMethod: string,
    data: Record<string, any>,
    headers: Record<string, any>,
    connection: Connection,
    raw: Record<string, any>,
    url: string
}

export = BaseOpenAPIClient;
type BaseOpenAPIClient = {
    isPublicInterface: boolean,
    getBody: Function,
    getResult: Function,
    serialize: Function,
    deserialize: Function,
    fromBuffer: Function,
    baseRequest(params?: RequestParams, cacheConfig?: CacheConfig): Promise<any>,
    mainRequest(params?: RequestParams): Promise<any>,
    cachedRequest(params?: RequestParams, cacheConfig?: CacheConfig): Promise<any>,
    request({ raw, command, url, httpMethod, data, headers, connection }?: {
        httpMethod: string,
        raw?: boolean,
        url?: string,
        command?: string,
        data: Record<string, any>,
        headers: Record<string, any>,
        connection: Connection
    }, resolve?: Function, reject?: Function): Promise<Record<string, any>>
}
