export = IteratorsQueue;
declare class IteratorsQueue {
  static createIteratorPlaceholder(requestId: string): string;
  static getIteratorTypeByCommand(methodName: string): 'iterator' | 'accessor';
  static createDataStoreKey(uid: string): string;
  static createIteratorDescriptor({ iterator, command }: {
        iterator: string,
        command: string
    }): string;

  constructor({ onLimitExceededCallbacks, tempDataStore, openApiClient }: {
        onLimitExceededCallbacks?: (({ connection, clearQueue }: {
            connection: Connection,
            clearQueue: () => Promise<unknown>
        }) => unknown)[],
        tempDataStore: unknown,
        openApiClient: openApiClient
    });

    onLimitExceededCallbacks: (({ connection, clearQueue }: {
        connection: Connection,
        clearQueue: () => Promise<unknown>
    }) => unknown)[];

    tempDataStore: unknown;
    openApiClient: unknown;
    getIteratorsForUser(clientUid: string): Promise<(iteratorPlaceholder | IteratorDescriptor)[]>;
    pushIterator({ clientUid, command, response }: {
        clientUid: string,
        command: string,
        response: {
            body: {
                wstrIteratorId: string, wstrIterator: string, strAccessor: string, PxgRetVal: unknown
            }
        }
    }): Promise<void>;

    removeIterator({ clientUid, command, iterator }: {
        clientUid: string,
        command: string,
        iterator: string
    }): Promise<void>;

    pushIteratorPlaceholder({ clientUid, requestId }: {
        clientUid: string,
        requestId: string
    }): Promise<void>;

    removeIteratorPlaceholder({ clientUid, requestId }: {
        clientUid: string,
        requestId: string
    }): Promise<void>;

    onLimitExceeded({ connection }: {
        connection: Connection
    }): Promise<void>;

    clearQueue({ connection }: {
        connection: Connection
    }): Promise<unknown[]>;
}
declare namespace IteratorsQueue {
    export { IteratorDescriptor, iteratorPlaceholder, openApiClient, Connection }
}
type Connection = {
    clientUid: string
};
type iteratorPlaceholder = string;
type IteratorDescriptor = string;
type openApiClient = unknown;
