import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import { OpenAPIIterator, VecFieldToOrder } from '../../data/common'
import BaseOpenAPIClient = require('../base-open-api-client');

export = AdHosts;

type OUAttributes = {
    adhst_id: number,
    adhst_idParent: number,
    adhst_binOu: string,
    adhst_idComputer: string,
    adhst_hostsNum: number,
    adhst_childSubunitsNum: number,
    adhst_enable_ad_scan: number
}

type AdGroupAttributes = {
    adhst_adgroup_id: number,
    adhst_adgroup_distinguished_name: string,
    adhst_adgroup_name: string,
    adhst_adgroup_sam_name: string
}

type AdGroupIterator = OpenAPIIterator<AdGroupAttributes>
type OUIterator = OpenAPIIterator<OUAttributes>

type AdHosts = BaseOpenAPIClient & {
    FindAdGroups({ vecFieldsToReturn, vecFieldsToOrder, pOptions, lMaxLifeTime }: {
        vecFieldsToReturn?: (keyof AdGroupAttributes)[],
        vecFieldsToOrder?: VecFieldToOrder[],
        pOptions?: { adhst_id: number },
        lMaxLifeTime?: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<AdGroupIterator>,
    GetChildOUs({ idOU, pFields, lMaxLifeTime }: {
        idOU?: number,
        pFields?: (keyof OUAttributes)[],
        lMaxLifeTime?: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<OUIterator>,
    GetOU({ idOU, pFields }: {
        idOU: number,
        pFields?: (keyof OUAttributes)[]
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<OUAttributes>,
    UpdateOU({ idOU, pData }: {
        idOU: number,
        pData: Partial<OUAttributes>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    GetChildComputers({ idOU, vecFieldsToReturn, lMaxLifeTime }: {
        idOU: number,
        vecFieldsToReturn?: string[],
        lMaxLifeTime?: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<OpenAPIIterator>
}
