import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import BaseOpenAPIClient = require('../base-open-api-client');

export = AdSecManager;

type PDetect = {
    KLHST_WKS_HOSTNAME: string,
    KLHST_WKS_PRODUCT_NAME: string,
    KLHST_WKS_PRODUCT_VERSION: string,
    ListItemId: string
}

type AdSecManagerParam = {
    pArrDetects: PDetect[]
}

type AdSecManager = BaseOpenAPIClient & {
    ApproveDetect(params: AdSecManagerParam, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    DisproveDetect(params: AdSecManagerParam, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>
}
