import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import { AdfsSsoSettings } from '../../additional/AdfsSsoSettings'
import { AdfsSsoJwks } from '../../additional/AdfsSsoJwks'
import BaseOpenAPIClient = require('../base-open-api-client');

export = AdfsSso;
type AdfsSso = BaseOpenAPIClient & {
    GetSettings({ bExtenedSettings }: {
        bExtenedSettings: boolean
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<AdfsSsoSettings>,
    GetJwks(noParams: null, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<AdfsSsoJwks>,
    SetSettings(pAdfsSettings: AdfsSsoSettings, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    SetAdfsEnabled({ bEnabled }: {
        bEnabled: boolean
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    GetAdfsEnabled(noParams: null, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<boolean>,
    CreateNonceAndStateForUserSession({ wstrUserSessionId }: {
        wstrUserSessionId: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<unknown>
}
