import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import BaseOpenAPIClient = require('../base-open-api-client');

export = AKPatches;

type AKPatchesOptions = {
    NeedBackupServer: boolean
}

type AKPatchesParams = {
    szwPatchId: string,
    parOptions: AKPatchesOptions
}

type AKPatchesResult = {
    CallResult: boolean,
    ErrorDescription: string
}

type AKPatches = BaseOpenAPIClient & {
    ApprovePatch(params: AKPatchesParams, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<AKPatchesResult>,
    ForbidPatch(params: AKPatchesParams, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<AKPatchesResult>
}
