import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import { CommonExecutionFileFromAppcontrol } from '../../additional/CommonExecutionFileFromAppcontrol'
import { ExecutionFileInstanceFromAppcontrol } from '../../additional/ExecutionFileInstanceFromAppcontrol'
import BaseOpenAPIClient = require('../base-open-api-client');

export = AppCtrlApi;

type ExecFile = CommonExecutionFileFromAppcontrol & ExecutionFileInstanceFromAppcontrol

type AppCtrlApi = BaseOpenAPIClient & {
    GetExeFileInfo(params: {
        lFileId: number, szwHostId: string, pFilter?: ExecFile
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<ExecFile>
}
