import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import BaseOpenAPIClient = require('../base-open-api-client');

export = Auth;
type Auth = BaseOpenAPIClient & {
    constructor(...args: unknown[]): Auth,
    login(params: {
        login: string,
        password: string,
        domain: string,
        isInternalUser: boolean,
        wstrAuthKey?: string,
        token?: string,
        webToken?: string,
        webConsoleToken?: string,
        securityCode?: string,
        isSuccessfullyConfirmedTotp?: boolean,
        headers?: Record<string, string>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<unknown>
}
