import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import { ParamBinary } from '../../data/common'
import BaseOpenAPIClient = require('../base-open-api-client');

export = CertPoolCtrl;
type CertPoolCtrl = BaseOpenAPIClient & {
    GetCertificateInfo({ nVServerId, nFunction }: {
        nVServerId: number,
        nFunction: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<{
        CPublic: ParamBinary
    }>,
    SetCertificate({ nVServerId, nFunction, pCertData }: {
        nVServerId: number,
        nFunction: number,
        pCertData: Record<string, unknown>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>
}
