import { ParamBinary, ParamDateTime } from '../../data/common'
import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import { AdminServerCertificateAttributes } from '../../additional/AdminServerCertificateAttributes';
import BaseOpenAPIClient = require('../base-open-api-client');

type GenSelfSeignedCertParams = Partial<{
    KLSRV_CERTUTILS_CERT_COMMON_NAME: string,
    KLSRV_CERTUTILS_CERT_DNS_NAMES: string,
    KLSRV_CERTUTILS_CERT_LIFE_TIME: ParamDateTime,
    KLSRV_CERTUTILS_CERT_EKU_SERVER: boolean,
    KLSRV_CERTUTILS_CERT_EKU_CLIENT: boolean
}>;

type SelfSignedCert = {
    KLSRV_CERTUTILS_CERT_PUBLIC_PART: ParamBinary,
    KLSRV_CERTUTILS_CERT_PRIVATE_PART: ParamBinary,
    KLSRV_CERTUTILS_CERT_PASSWORD: string,
    KLSRV_CERTUTILS_CERT_HASH: string
}

export = CertUtils;
type CertUtils = BaseOpenAPIClient & {
    GetCertificateAttributes({ pCertificateFileChunk }: {
        pCertificateFileChunk: string | ParamBinary
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<AdminServerCertificateAttributes>,
    GenerateSelfSignedCertificate({ pParams }: {
        pParams: GenSelfSeignedCertParams
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<SelfSignedCert>,
    Certificate2Params({ pCert, pwchPassword }: {
        pCert: string,
        pwchPassword: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<AdminServerCertificateAttributes>
}
