import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import BaseOpenAPIClient = require('../base-open-api-client');

export = ChunkAccessor;
type ChunkAccessor = BaseOpenAPIClient & {
    GetItemsChunk<T = unknown>({ strAccessor, nStart, nCount }: {
        strAccessor: string,
        nStart?: number,
        nCount: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<T[]>,
    GetItemsCount({ strAccessor }: {
        strAccessor: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<number>,
    Release({ strAccessor }: {
        strAccessor: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>
}
