import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import { ParamBinary } from '../../data/common'
import { CloudType } from '../../constants/CloudType'
import BaseOpenAPIClient = require('../base-open-api-client')

export = CloudAccess;

type AuthSettings = {
    CLIENT_SECRET: ParamBinary,
    CLIENT_ID: string,
    AZURE_APP_ID: string,
    AZURE_STORAGE_NAME: string,
    AZURE_STORAGE_KEY: ParamBinary
}

type CloudAccess = BaseOpenAPIClient & {
    AcquireAccessForKeyPair<CT extends CloudType>({ enCloudType, pKeyPair }: {
        enCloudType: CT,
        pKeyPair: Pick<AuthSettings, 'CLIENT_ID' | 'CLIENT_SECRET'>
            & (CT extends (CloudType.KLCLOUD_TYPE_GOOGLE | CloudType.KLCLOUD_TYPE_AZURE) ? Pick<AuthSettings, 'AZURE_APP_ID'> : {})
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<{
        bAllowScanning: boolean;
        bAllowDeployment: boolean;
    }>,
    VerifyCredentials({ enCloudType, pKeyPair }: {
        enCloudType: CloudType,
        pKeyPair: Partial<Pick<AuthSettings, 'CLIENT_SECRET'>>
            & (Pick<AuthSettings, 'CLIENT_ID' | 'AZURE_APP_ID'> | {})
            & (Pick<AuthSettings, 'AZURE_STORAGE_NAME' | 'AZURE_STORAGE_KEY'> | {})
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<boolean>
}
